# The role of artifcial intelligence in healthcare: a structured literature review

Silvana Secinaro1 , Davide Calandra1\*, Aurelio Secinaro2 , Vivek Muthurangu3 and Paolo Biancone1

# Abstract

Background/Introduction: Artifcial intelligence (AI) in the healthcare sector is receiving attention from researchers and health professionals. Few previous studies have investigated this topic from a multi-disciplinary perspective, including accounting, business and management, decision sciences and health professions.

Methods: The structured literature review with its reliable and replicable research protocol allowed the researchers to extract 288 peer-reviewed papers from Scopus. The authors used qualitative and quantitative variables to analyse authors, journals, keywords, and collaboration networks among researchers. Additionally, the paper benefted from the Bibliometrix R software package.

Results: The investigation showed that the literature in this feld is emerging. It focuses on health services management, predictive medicine, patient data and diagnostics, and clinical decision-making. The United States, China, and the United Kingdom contributed the highest number of studies. Keyword analysis revealed that AI can support physicians in making a diagnosis, predicting the spread of diseases and customising treatment paths.

Conclusions: The literature reveals several AI applications for health services and a stream of research that has not fully been covered. For instance, AI projects require skills and data quality awareness for data-intensive analysis and knowledge-based management. Insights can help researchers and health professionals understand and address future research on AI in the healthcare feld.

Keywords: Artifcial intelligence, Healthcare, Patient data, Clinical decision-making, Management

# Background

Artifcial intelligence (AI) generally applies to computational technologies that emulate mechanisms assisted by human intelligence, such as thought, deep learning, adaptation, engagement, and sensory understanding [1, 2]. Some devices can execute a role that typically involves human interpretation and decision-making [3, 4]. Tese techniques have an interdisciplinary approach and can be applied to diferent felds, such as medicine and health. AI has been involved in medicine since as early as the 1950s, when physicians made the frst attempts to improve their diagnoses using computer-aided programs [5, 6]. Interest and advances in medical AI applications have surged in recent years due to the substantially enhanced computing power of modern computers and the vast amount of digital data available for collection and utilisation [7]. AI is gradually changing medical practice. Tere are several AI applications in medicine that can be used in a variety of medical felds, such as clinical, diagnostic, rehabilitative, surgical, and predictive practices. Another critical area of medicine where AI is making an impact is clinical decision-making and disease diagnosis. AI technologies can ingest, analyse, and report large volumes of data across diferent modalities to detect disease and guide clinical decisions [3, 8]. AI applications can deal with the vast amount of data produced in medicine and fnd new information that would otherwise remain hidden in the mass of medical big data [9–11]. Tese technologies can also identify new drugs for health services management and patient care treatments [5, 6].

Courage in the application of AI is visible through a search in the primary research databases. However, as Meskò et  al. [7] fnd, the technology will potentially reduce care costs and repetitive operations by focusing the medical profession on critical thinking and clinical creativity. As Cho et  al. and Doyle et  al. [8, 9] add, the AI perspective is exciting; however, new studies will be needed to establish the efcacy and applications of AI in the medical feld [10].

Our paper will also concentrate on AI strategies for healthcare from the accounting, business, and management perspectives. Te authors used the structured literature review (SLR) method for its reliable and replicable research protocol [11] and selected bibliometric variables as sources of investigation. Bibliometric usage enables the recognition of the main quantitative variables of the study stream [12]. Tis method facilitates the detection of the required details of a particular research subject, including feld authors, number of publications, keywords for interaction between variables (policies, properties and governance) and country data [13]. It also allows the application of the science mapping technique [14]. Our paper adopted the Bibliometrix R package and the biblioshiny web interface as tools of analysis [14].

Te investigation ofers the following insights for future researchers and practitioners:

(a) bibliometric information on 288 peer-reviewed English papers from the Scopus collection.   
(b) Identifcation of leading journals in this feld, such as Journal of Medical Systems, Studies in Health Technology and Informatics, IEEE Journal of Biomedical and Health Informatics, and Decision Support Systems.   
(c) Qualitative and quantitative information on authors’ Lotka’s law, h-index, g-index, m-index, keyword, and citation data.   
(d) Research on specifc countries to assess AI in the delivery and efectiveness of healthcare, quotes, and networks within each region.   
(e) A topic dendrogram study that identifes fve research clusters: health services management, predictive medicine, patient data, diagnostics, and fnally, clinical decision-making.   
(f ) An in-depth discussion that develops theoretical and practical implications for future studies.

Te paper is organised as follows. Section  2 lists the main bibliometric articles in this feld. Section  3 elaborates on the methodology. Section 4 presents the fndings of the bibliometric analysis. Section 5 discusses the main elements of AI in healthcare based on the study results. Section  6 concludes the article with future implications for research.

# Related works and originality

As suggested by Zupic and Čater [15], a research stream can be evaluated with bibliometric methods that can introduce objectivity and mitigate researcher bias. For this reason, bibliometric methods are attracting increasing interest among researchers as a reliable and impersonal research analytical approach [16, 17]. Recently, bibliometrics has been an essential method for analysing and predicting research trends [18]. Table  1 lists other research that has used a similar approach in the research stream investigated.

Te scientifc articles reported show substantial differences in keywords and research topics that have been previously studied. Te bibliometric analysis of Huang et al. [19] describes rehabilitative medicine using virtual reality technology. According to the authors, the primary goal of rehabilitation is to enhance and restore functional ability and quality of life for patients with physical impairments or disabilities. In recent years, many healthcare disciplines have been privileged to access various technologies that provide tools for both research and clinical intervention.

Table 1 List of research using bibliometric analysis. Source: Authors’ elaboration   

<html><body><table><tr><td>References</td><td>Field</td></tr><tr><td>Huang et al. [1]</td><td>Rehabilitation medicine</td></tr><tr><td>Hao et al. [2]</td><td>Text mining in medical research</td></tr><tr><td>Liao et al. [3]</td><td>Medical big data Global evolution of research on Al in health and medicine</td></tr><tr><td>dos Santos et al. [4]</td><td>Data mining and machine learning techniques applied to public health problems</td></tr><tr><td>Connelly et al. [5]</td><td>Robotic surgery</td></tr><tr><td>Guo et al. [6]</td><td>Al-related research conducted in the field of health problems</td></tr><tr><td>Choudhury et al. [7]</td><td>Machine learning in geriatric clinical</td></tr><tr><td>Choudhury and Asan [8]</td><td>Al in patient safety outcomes</td></tr><tr><td>This paper</td><td>Al techniques for clinical decision-making and data management quality in healthcare</td></tr></table></body></html>

Hao et  al. [20] focus on text mining in medical research. As reported, text mining reveals new, previously unknown information by using a computer to automatically extract information from diferent text resources. Text mining methods can be regarded as an extension of data mining to text data. Text mining is playing an increasingly signifcant role in processing medical information. Similarly, the studies by dos Santos et  al. [21] focus on applying data mining and machine learning (ML) techniques to public health problems. As stated in this research, public health may be defned as the art and science of preventing diseases, promoting health, and prolonging life. Using data mining and ML techniques, it is possible to discover new information that otherwise would be hidden. Tese two studies are related to another topic: medical big data. According to Liao et al. [22], big data is a typical “buzzword” in the business and research community, referring to a great mass of digital data collected from various sources. In the medical feld, we can obtain a vast amount of data (i.e., medical big data). Data mining and ML techniques can help deal with this information and provide helpful insights for physicians and patients. More recently, Choudhury et al. [23] provide a systematic review on the use of ML to improve the care of elderly patients, demonstrating eligible studies primarily in psychological disorders and eye diseases.

Tran et  al. [2] focus on the global evolution of AI research in medicine. Teir bibliometric analysis highlights trends and topics related to AI applications and techniques. As stated in Connelly et  al.’s [24] study, robot-assisted surgeries have rapidly increased in recent years. Teir bibliometric analysis demonstrates how robotic-assisted surgery has gained acceptance in different medical felds, such as urological, colorectal, cardiothoracic, orthopaedic, maxillofacial and neurosurgery applications. Additionally, the bibliometric analysis of Guo et al. [25] provides an in-depth study of AI publications through December 2019. Te paper focuses on tangible AI health applications, giving researchers an idea of how algorithms can help doctors and nurses. A new stream of research related to AI is also emerging. In this sense, Choudhury and Asan’s [26] scientifc contribution provides a systematic review of the AI literature to identify health risks for patients. Tey report on 53 studies involving technology for clinical alerts, clinical reports, and drug safety. Considering the considerable interest within this research stream, this analysis difers from the current literature for several reasons. It aims to provide in-depth discussion, considering mainly the business, management, and accounting felds and not dealing only with medical and health profession publications.

Additionally, our analysis aims to provide a bibliometric analysis of variables such as authors, countries, citations and keywords to guide future research perspectives for researchers and practitioners, as similar analyses have done for several publications in other research streams [15, 16, 27]. In doing so, we use a diferent database, Scopus, that is typically adopted in social sciences felds. Finally, our analysis will propose and discuss a dominant framework of variables in this feld, and our analysis will not be limited to AI application descriptions.

# Methodology

Tis paper evaluated AI in healthcare research streams using the SLR method [11]. As suggested by Massaro et al. [11], an SLR enables the study of the scientifc corpus of a research feld, including the scientifc rigour, reliability and replicability of operations carried out by researchers. As suggested by many scholars, the methodology allows qualitative and quantitative variables to highlight the best authors, journals and keywords and combine a systematic literature review and bibliometric analysis [27–30]. Despite its widespread use in business and management [16, 31], the SLR is also used in the health sector based on the same philosophy through which it was originally conceived [32, 33]. A methodological analysis of previously published articles reveals that the most frequently used steps are as follows [28, 31, 34]:

1. defning research questions;   
2. writing the research protocol;   
3. defning the research sample to be analysed;   
4. developing codes for analysis; and   
5. critically analysing, discussing, and identifying a   
future research agenda.

Considering the above premises, the authors believe that an SLR is the best method because it combines scientifc validity, replicability of the research protocol and connection between multiple inputs.

As stated by the methodological paper, the frst step is research question identifcation. For this purpose, we beneft from the analysis of Zupic and Čater [15], who provide several research questions for future researchers to link the study of authors, journals, keywords and citations. Terefore, RQ1 is “What are the most prominent authors, journal keywords and citations in the feld of the research study?” Additionally, as suggested by Haleem et al. [35], new technologies, including AI, are changing the medical feld in unexpected timeframes, requiring studies in multiple areas. Terefore, RQ2 is “How does artifcial intelligence relate to healthcare, and what is the focus of the literature?” Ten, as discussed by Massaro et al. [36], RQ3 is “What are the research applications of artifcial intelligence for healthcare?”.

Te frst research question aims to defne the qualitative and quantitative variables of the knowledge fow under investigation. Te second research question seeks to determine the state of the art and applications of AI in healthcare. Finally, the third research question aims to help researchers identify practical and theoretical implications and future research ideas in this feld.

Te second fundamental step of the SLR is writing the research protocol [11]. Table  2 indicates the currently known literature elements, uniquely identifying the research focus, motivations and research strategy adopted and the results providing a link with the following points. Additionally, to strengthen the analysis, our investigation benefts from the PRISMA statement methodological article [37]. Although the SLR is a validated method for systematic reviews and meta-analyses, we believe that the workfow provided may beneft the replicability of the results [37–40]. Figure 1 summarises the researchers’ research steps, indicating that there are no results that can be referred to as a meta-analysis.

Te third step is to specify the search strategy and search database. Our analysis is based on the search string “Artifcial Intelligence” OR “AI” AND “Healthcare” with a focus on “Business, Management, and Accounting”, “Decision Sciences”, and “Health professions”. As suggested by [11, 41] and motivated by [42], keywords can be selected through a top-down approach by identifying a large search feld and then focusing on particular sub-topics. Te paper uses data retrieved from the Scopus database, a multi-disciplinary database, which allowed the researchers to identify critical articles for scientifc analysis [43]. Additionally, Scopus was selected based on Guo et al.’s [25] limitations, which suggest that “future studies will apply other databases, such as Scopus, to explore more potential papers”. Te research focuses on articles and reviews published in peer-reviewed journals for their scientifc relevance [11, 16, 17, 29] and does not include the grey literature, conference proceedings or books/book chapters. Articles written in any language other than English were excluded [2]. For transparency and replicability, the analysis was conducted on 11 January 2021. Using this research strategy, the authors retrieved 288 articles. To strengthen the study’s reliability, we publicly provide the full bibliometric extract on the Zenodo repository [44, 45].

Te fourth research phase is defning the code framework that initiates the analysis of the variables. Te study will identify the following:

(1) descriptive information of the research area;   
(2) source analysis [16];   
(3) author and citation analysis [28];   
(4) keywords and network analysis [14]; and (5) geographic distribution of the papers [14].

Te fnal research phase is the article’s discussion and conclusion, where implications and future research trends will be identifed.

At the research team level, the information is analysed with the statistical software R-Studio and the Bibliometrix package [15], which allows scientifc analysis of the results obtained through the multi-disciplinary database.

# Results

Te analysis of bibliometric results starts with a description of the main bibliometric statistics with the aim of answering RQ1, What are the most prominent authors, journal keywords and citations in the feld of the research study?, and RQ2, How does artifcial intelligence relate to healthcare, and what is the focus of the literature? Terefore, the following elements were thoroughly analysed: (1) type of document; (2) annual scientifc production; (3) scientifc sources; (4) source growth; (5) number of articles per author; (6) author’s dominance ranking; (7) author’s h-index, g-index, and m-index; (8) author’s productivity; (9) author’s keywords; (10) topic dendrogram; (11) a factorial map of the document with the highest contributions; (12) article citations; (13) country production; (14) country citations; (15) country collaboration map; and (16) country collaboration network.

Table 2 SLR protocol and results obtained from Scopus. Source: Authors’ elaboration   

<html><body><table><tr><td>Reviewprotocol elements</td><td>Authors&#x27;consideration</td><td>Results in terms of sources</td></tr><tr><td>What is already known? and</td><td>Artificial Inteligence (Al) is a novel topic based on already known knowledge,which has several healthcare implications.Due to its continuous growth,there is the potential fora structured litera- ture review (SLR) investigating how Al can contribute to healthcare implementation</td><td>5069 results</td></tr><tr><td>Research topics</td><td>Journals&#x27;andtematiciitatioWedidedotoiiteesearchtoidilsientifjouralbauseofthtlloung9slts scope,as our analysis period.Therefore,our analysis is broad in terms of themes and period under investigation.It considers the following research streams: accounting,business,and management;</td><td></td></tr><tr><td>Other restrictive elements</td><td>health professions Authors selectedonly peer-reviewed articlesand reviews,excluding conference proceedings,books288 results and books chapters.Finally,only sources written in English are considered</td><td></td></tr><tr><td>Period of analysis</td><td>January 2021</td><td></td></tr></table></body></html>

![](images/2dd6291d49f0595e2bb76324d760d3835deaeeaa5cea4f29cdd5ce20ba782b10.jpg)  
Fig. 1 PRISMA workfow. Source: Authors’ elaboration on Liberati et al. [37]

# Main information

Table 3 shows the information on 288 peer-reviewed articles published between 1992 and January 2021 extracted from the Scopus database. Te number of keywords is

946 from 136 sources, and the number of keywords plus, referring to the number of keywords that frequently appear in an article’s title, was 2329. Te analysis period covered 28  years and 1  month of scientifc production and included an annual growth rate of $5 . 1 2 \%$ . However, the most signifcant increase in published articles occurred in the past three years (please see Fig.  2). On average, each article was written by three authors (3.56). Finally, the collaboration index (CI), which was calculated as the total number of authors of multi-authored articles/ total number of multi-authored articles, was 3.97 [46].

Table  4 shows the top 20 sources related to the topic. Te Journal of Medical Systems is the most relevant source, with twenty-one of the published articles. Tis journal’s main issues are the foundations, functionality, interfaces, implementation, impacts, and evaluation of medical technologies. Another relevant source is Studies in Health Technology and Informatics, with eleven articles. Tis journal aims to extend scientifc knowledge related to biomedical technologies and medical informatics research. Both journals deal with cloud computing, machine learning, and AI as a disruptive healthcare paradigm based on recent publications. Te IEEE Journal of Biomedical and Health Informatics investigates technologies in health care, life sciences, and biomedicine applications from a broad perspective. Te next journal, Decision Support Systems, aims to analyse how these technologies support decision-making from a multi-disciplinary view, considering business and management.

Table 3 Main information. Source: Authors’ elaboration   

<html><body><table><tr><td>Main information</td><td>Explanation</td><td>No</td></tr><tr><td>Documents</td><td>Total number of scientific papers and review</td><td>288</td></tr><tr><td>Sources</td><td>The frequency distribution of sources as journals</td><td>136</td></tr><tr><td>Author&#x27;s keywords</td><td>Total number of keywords</td><td>946</td></tr><tr><td>Keywords plus (ID)</td><td>Total number of phrases that frequently appear in the title of an article&#x27;s references</td><td>2329</td></tr><tr><td>Period</td><td>Years of publication</td><td>1992-2021</td></tr><tr><td>Authors</td><td>Total number of authors</td><td>1025</td></tr><tr><td>Authors appearances</td><td>The authors&#x27;frequency distribution</td><td>1059</td></tr><tr><td>Authors of single-authored documents</td><td>The number of single authors per articles</td><td>36</td></tr><tr><td>Authors of multi-authored documents</td><td>The number of authors of multi-authored articles</td><td>989</td></tr><tr><td>Authors per document</td><td>The average number of authors in each document</td><td>3.56</td></tr><tr><td>Co-authors per documents</td><td>The average number of co-authors in each document</td><td>3.68</td></tr><tr><td>Average citations per article</td><td>The average number of quotes in each article</td><td>12.68</td></tr><tr><td>Collaboration index (Cl)</td><td></td><td>3.97</td></tr></table></body></html>

![](images/92c1bb002252d1ac926dbd88b84280287279de64eb50fcf1f2353b573c2dc14f.jpg)  
Fig. 2 Annual scientifc production. Source: Authors’ elaboration

Terefore, the analysis of the journals revealed that we are dealing with an interdisciplinary research feld. Tis conclusion is confrmed, for example, by the presence of purely medical journals, journals dedicated to the technological growth of healthcare, and journals with a longterm perspective such as futures.

Te distribution frequency of the articles (Fig. 3) indicates the journals dealing with the topic and related issues. Between 2008 and 2012, a signifcant growth in the number of publications on the subject is noticeable. However, the graph shows the results of the Loess regression, which includes the quantity and publication time of the journal under analysis as variables. Tis method allows the function to assume an unlimited distribution; that is, feature can consider values below zero if the data are close to zero. It contributes to a better visual result and highlights the discontinuity in the publication periods [47].

Table 4 Main twenty sources. Source: Authors’ elaboration   

<html><body><table><tr><td>Top 20 sources</td><td>No of articles</td></tr><tr><td>Journal of Medical Systems</td><td>21</td></tr><tr><td>Studies in Health Technology and Informatics</td><td>18</td></tr><tr><td>IEEE Journal of Biomedical and Health Informatics</td><td>17</td></tr><tr><td>Decision Support Systems</td><td>11</td></tr><tr><td>Healthcare Informatics Research</td><td>11</td></tr><tr><td>International Journal of Scientific and Technology Research</td><td>8</td></tr><tr><td>International Journal of Recent Technology and Engineering</td><td>7</td></tr><tr><td> Journal of Digital Imaging</td><td>7</td></tr><tr><td>NPJ Digital Medicine</td><td>5</td></tr><tr><td>Physiotherapy Theory and Practice</td><td>5</td></tr><tr><td>Telemedicine and E-Health</td><td>5</td></tr><tr><td>Biomedical Engineering Online</td><td>4</td></tr><tr><td>Information Sciences</td><td>4</td></tr><tr><td>International Journal of Healthcare Information Systems and Informatics</td><td>4</td></tr><tr><td>BMJ Health and Care Informatics</td><td>3</td></tr><tr><td>Futures</td><td>3</td></tr><tr><td>International Journal on Emerging Technologies</td><td>3</td></tr><tr><td>Journal ofthe Operational Research Society</td><td>3</td></tr><tr><td>Judgement and Decision Making</td><td>3</td></tr><tr><td>Medical Image Analysis</td><td>3</td></tr></table></body></html>

![](images/fcb1dffe498313575a6a6ffc480ebc287a14e5f2022d592bd76a99295fa1ef05.jpg)  
Fig. 3 Source growth. Source: Authors’ elaboration

Finally, Fig. 4 provides an analytical perspective on factor analysis for the most cited papers. As indicated in the literature [48, 49], using factor analysis to discover the most cited papers allows for a better understanding of the scientifc world’s intellectual structure. For example, our research makes it possible to consider certain publications that efectively analyse subject specialisation. For instance, Santosh’s [50] article addresses the new paradigm of AI with ML algorithms for data analysis and decision support in the COVID-19 period, setting a benchmark in terms of citations by researchers.

Moving on to the application, an article by Shickel et al. [51] begins with the belief that the healthcare world currently has much health and administrative data. In this context, AI and deep learning will support medical and administrative staf in extracting data, predicting outcomes, and learning medical representations. Finally, in the same line of research, Baig et al. [52], with a focus on wearable patient monitoring systems (WPMs), conclude that AI and deep learning may be landmarks for continuous patient monitoring and support for healthcare delivery.

# Authors

Tis section identifes the most cited authors of articles on AI in healthcare. It also identifes the authors’ keywords, dominance factor (DF) ranking, h-index, productivity, and total number of citations. Table  5 identifes the authors and their publications in the top 20 rankings.

![](images/bac85cf6d72a6f60adf4cfded7c9e9acf52c755699af68921c9e506f8db93b30.jpg)  
Fig. 4 Factorial map of the most cited documents. Source: Authors’ elaboration

Table 5 Most cited authors. Source: Authors’ elaboration   

<html><body><table><tr><td>Number of articles</td><td>Authors (top 20)</td></tr><tr><td>4</td><td>Bushko, RG</td></tr><tr><td>3</td><td>Liu C</td></tr><tr><td></td><td>Sharma, A</td></tr><tr><td>2</td><td>Attia,S</td></tr><tr><td></td><td>Beckstead, JW</td></tr><tr><td></td><td>Bonezzi, A</td></tr><tr><td></td><td>Boubetra,A</td></tr><tr><td></td><td>Chang, H</td></tr><tr><td></td><td>Chang,V</td></tr><tr><td></td><td>Clifton,DA</td></tr><tr><td></td><td>Das,S</td></tr><tr><td></td><td>Fan,W</td></tr><tr><td></td><td>Fox,J</td></tr><tr><td></td><td>Kalhori,SRN</td></tr><tr><td></td><td>Khan,O</td></tr><tr><td></td><td>Liu,J</td></tr><tr><td></td><td>Longoni, C</td></tr><tr><td></td><td>Luo, G</td></tr><tr><td></td><td>Michalowski,W</td></tr><tr><td></td><td>Morewedge, CK</td></tr></table></body></html>

As the table shows, Bushko R.G. has the highest number of publications: four papers. He is the editor-in-chief of Future of Health Technology, a scientifc journal that aims to develop a clear vision of the future of health technology. Ten, several authors each wrote three papers. For instance, Liu C. is a researcher active in the topic of ML and computer vision, and Sharma A. from Emory University Atlanta in the USA is a researcher with a clear focus on imaging and translational informatics. Some other authors have two publications each. While some authors have published as primary authors, most have published as co-authors. Hence, in the next section, we measure the contributory power of each author by investigating the DF ranking through the number of elements.

felds where the frst author is entered by surname alphabetical order [55].

Te mathematical equation for the DF is shown as:

$$
D F = { \frac { N m f } { N m t } }
$$

Te dominance factor (DF) is a ratio measuring the fraction of multi-authored articles in which an author acts as the frst author [53]. Several bibliometric studies use the DF in their analyses [46, 54]. Te DF ranking calculates an author’s dominance in producing articles. Te DF is calculated by dividing the number of an author’s multiauthored papers as the frst author (Nmf ) by the author’s total number of multi-authored papers (Nmt). Tis is omitted in the single-author case due to the constant value of 1 for single-authored articles. Tis formulation could lead to some distortions in the results, especially in

# Authors’ dominance ranking

Table  6 lists the top $2 0 ~ \mathrm { D F }$ rankings. Te data in the table show a low level of articles per author, either for frst-authored or multi-authored articles. Te results demonstrate that we are dealing with an emerging topic in the literature. Additionally, as shown in the table, Fox J. and Longoni C. are the most dominant authors in the feld.

# Authors’ impact

Table  7 shows the impact of authors in terms of the h-index [56] (i.e., the productivity and impact of citations of a researcher), $\mathbf { g }$ -index [57] (i.e., the distribution of citations received by a researcher’s publications), m-index [58] (i.e., the h-index value per year), total citations, total paper and years of scientifc publication. Te H-index was introduced in the literature as a metric for the objective comparison of scientifc results and depended on the number of publications and their impact [59]. Te results show that the 20 most relevant authors have an $_ \mathrm { h }$ -index between 2 and 1. For the practical interpretation of the data, the authors considered data published by the London School of Economics [60]. In the social sciences, the analysis shows values of 7.6 for economic publications by professors and researchers who had been active for several years. Terefore, the youthfulness of the research area has attracted young researchers and professors. At the same time, new indicators have emerged over the years to diversify the logic of the h-index. For example, the $\mathbf { g }$ -index indicates an author’s impact on citations, considering that a single article can generate these. Te m-index, on the other hand, shows the cumulative value over the years.

Te analysis, also considering the total number of citations, the number of papers published and the year of starting to publish, thus confrms that we are facing an expanding research fow.

# Authors’ productivity

Figure  5 shows Lotka’s law. Tis mathematical formulation originated in 1926 to describe the publication frequency by authors in a specifc research feld [61]. In practice, the law states that the number of authors contributing to research in a given period is a fraction of the number who make up a single contribution [14, 61].

Te mathematical relationship is expressed in reverse in the following way:

Table 6 Authors dominance factor. Source: Authors’ elaboration   

<html><body><table><tr><td>Rank by DF</td><td>Author</td><td>Dominance factor</td><td>Total articles</td><td>Multi-authored</td><td>First-authored</td><td>Rank by articles</td></tr><tr><td>1</td><td>Fox,J</td><td>1.0000</td><td>2</td><td>2</td><td>2</td><td>2</td></tr><tr><td>1</td><td>Longoni, C</td><td>1.0000</td><td>2</td><td>2</td><td>2</td><td>2</td></tr><tr><td></td><td>Luo,G</td><td>1.0000</td><td>2</td><td>1</td><td>1</td><td>2</td></tr><tr><td></td><td>Pezzo,MV</td><td>1.0000</td><td>2</td><td>2</td><td>2</td><td>2</td></tr><tr><td></td><td>Saoud, MS</td><td>1.0000</td><td>2</td><td>2</td><td>2</td><td>2</td></tr><tr><td></td><td>Abdel-Basset, M</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td></td><td>Abderrahman,B</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td></td><td>Abhari, S</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td>1</td><td>Achunair, A</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td>1</td><td>Adde,L</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td>1</td><td>Aggarwal,L</td><td>1.0000</td><td>1</td><td>1</td><td>1</td><td>14</td></tr><tr><td>1</td><td>Clifton, DA</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Das,S</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Fan,W</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Liu,J</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Sonnessa,M</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Young, A</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>13</td><td>Zhang,J</td><td>0.5000</td><td>2</td><td>2</td><td>1</td><td>2</td></tr><tr><td>20</td><td>Sharma,A</td><td>0.3333</td><td>3</td><td>3</td><td>1</td><td>1</td></tr></table></body></html>

Table 7 Authors impact. Source: Authors’ elaboration   

<html><body><table><tr><td>Author</td><td>h-index</td><td>g-index</td><td>m-index</td><td>Total citations</td><td>Total papers</td><td>Year Start</td></tr><tr><td>Bushko RG</td><td>1</td><td>2</td><td>0.050</td><td>4</td><td>4</td><td>2002</td></tr><tr><td>Liu C</td><td>2</td><td>3</td><td>0.500</td><td>10</td><td>3</td><td>2018</td></tr><tr><td>Sharma A</td><td>1</td><td>1</td><td>0.167</td><td>1</td><td>3</td><td>2016</td></tr><tr><td>Attia S</td><td>2</td><td>2</td><td>0.333</td><td>7</td><td>2</td><td>2016</td></tr><tr><td>Beckstead JW</td><td>1</td><td>1</td><td>0.500</td><td>2</td><td>2</td><td>2020</td></tr><tr><td>Bonezzi A</td><td>2</td><td>2</td><td>0.667</td><td>46</td><td>2</td><td>2019</td></tr><tr><td>Boubetra A</td><td>2</td><td>2</td><td>0.333</td><td>7</td><td>2</td><td>2016</td></tr><tr><td>Chang H</td><td>1</td><td>2</td><td>0.200</td><td>8</td><td>2</td><td>2017</td></tr><tr><td>Chang V</td><td>1</td><td>2</td><td>0.250</td><td>14</td><td>2</td><td>2018</td></tr><tr><td>Clifton DA</td><td>1</td><td>2</td><td>0.111</td><td>20</td><td>2</td><td>2013</td></tr><tr><td>Das S</td><td>1</td><td>1</td><td>0.333</td><td>3</td><td>2</td><td>2019</td></tr><tr><td>Fan W</td><td>2</td><td>2</td><td>1.000</td><td>20</td><td>2</td><td>2020</td></tr><tr><td>FoxJ</td><td>1</td><td>1</td><td>0.500</td><td>2</td><td>2</td><td>2020</td></tr><tr><td>Kalhori SRN</td><td>2</td><td>2</td><td>0.400</td><td>13</td><td>2</td><td>2017</td></tr><tr><td>Khan O</td><td>1</td><td>1</td><td>0.500</td><td>2</td><td>2</td><td>2020</td></tr><tr><td>Liu J</td><td>1</td><td>2</td><td>0.250</td><td>11</td><td>2</td><td>2018</td></tr><tr><td>LongoniC</td><td>2</td><td>2</td><td>0.667</td><td>46</td><td>2</td><td>2019</td></tr><tr><td>Luo G</td><td>2</td><td>2</td><td>0.200</td><td>20</td><td>2</td><td>2012</td></tr><tr><td>Michalowski W</td><td>2</td><td>2</td><td>0.154</td><td>14</td><td>2</td><td>2009</td></tr><tr><td>Morewedge CK</td><td>2</td><td>2</td><td>0.667</td><td>46</td><td>2</td><td>2019</td></tr></table></body></html>

![](images/bb1f3b838b7cceda33bbb155897bfa79912eddc517bb07804c6b0e286a2b10e0.jpg)  
Fig. 5 Lotka’s law. Source: Authors’ elaboration

$$
x ^ { n } * y _ { x } = C
$$

where $\mathrm { y _ { x } }$ is equal to the number of authors producing x articles in each research feld. Terefore, C and n are constants that can be estimated in the calculation.

Te fgure’s results are in line with Lotka’s results, with an average of two publications per author in a given research feld. In addition, the fgure shows the percentage of authors. Our results lead us to state that we are dealing with a young and growing research feld, even with this analysis. Approximately $7 0 \%$ of the authors had published only their frst research article. Only approximately $2 0 \%$ had published two scientifc papers.

# Authors’ keywords

Tis section provides information on the relationship between the keywords artifcial intelligence and healthcare. Tis analysis is essential to determine the research trend, identify gaps in the discussion on AI in healthcare, and identify the felds that can be interesting as research areas [42, 62].

Table  8 highlights the total number of keywords per author in the top 20 positions. Te ranking is based on the following elements: healthcare, artifcial intelligence, and clinical decision support system. Keyword analysis confrms the scientifc area of reference. In particular, we deduce the defnition as “Artifcial intelligence is the theory and development of computer systems able to perform tasks normally requiring human intelligence, such as visual perception, speech recognition, decision-making, and translation between languages” [2, 63]. Panch et al. [4] fnd that these technologies can be used in diferent business and management areas. After the frst keyword, the analysis reveals AI applications and related research such as machine learning and deep learning.

Table 8 Author’s keywords in articles on artifcial intelligence in healthcare. Source: Authors’ elaboration   

<html><body><table><tr><td>Author keywords (top 20)</td><td>Occurrences</td></tr><tr><td>Artificial intelligence</td><td>64</td></tr><tr><td>Machine learning</td><td>34</td></tr><tr><td>Healthcare</td><td>31</td></tr><tr><td>Deep learning</td><td>19</td></tr><tr><td>Data mining</td><td>10</td></tr><tr><td>Big data</td><td>9</td></tr><tr><td>Decision support system</td><td>9</td></tr><tr><td>Natural language processing</td><td>9</td></tr><tr><td>Data analytics</td><td>7</td></tr><tr><td>Decision support systems</td><td>7</td></tr><tr><td>Classification</td><td>6</td></tr><tr><td>COVID-19</td><td>6</td></tr><tr><td>Predictive analysis</td><td>6</td></tr><tr><td>Telemedicine</td><td>6</td></tr><tr><td>Al</td><td>5</td></tr><tr><td>Clinical decision support system</td><td>5</td></tr><tr><td>Descriptive analysis</td><td>5</td></tr><tr><td>Internet of things</td><td>5</td></tr><tr><td>Medical informatics</td><td>5</td></tr><tr><td>mHealth</td><td>5</td></tr></table></body></html>

Additionally, data mining and big data are a step forward in implementing exciting AI applications. According to our specifc interest, if we applied AI in healthcare, we would achieve technological applications to help and support doctors and medical researchers in decisionmaking. Te link between AI and decision-making is the reason why we fnd, in the seventh position, the keyword clinical decision support system. AI techniques can unlock clinically relevant information hidden in the massive amount of data that can assist clinical decision-making [64]. If we analyse the following keywords, we fnd other elements related to decision-making and support systems.

Te TreeMap below (Fig. 6) highlights the combination of possible keywords representing AI and healthcare.

Te topic dendrogram in Fig.  7 represents the hierarchical order and the relationship between the keywords generated by hierarchical clustering [42]. Te cut in the fgure and the vertical lines facilitate an investigation and interpretation of the diferent clusters. As stated by Andrews [48], the fgure is not intended to fnd the perfect level of associations between clusters. However, it aims to estimate the approximate number of clusters to facilitate further discussion.

Te research stream of AI in healthcare is divided into two main strands. Te blue strand focuses on medical information systems and the internet. Some papers are related to healthcare organisations, such as the Internet of Tings, meaning that healthcare organisations use AI to support health services management and data analysis. AI applications are also used to improve diagnostic and therapeutic accuracy and the overall clinical treatment process [2]. If we consider the second block, the red one, three diferent clusters highlight separate aspects of the topic. Te frst could be explained as AI and ML predictive algorithms. Trough AI applications, it is possible to obtain a predictive approach that can ensure that patients are better monitored. Tis also allows a better understanding of risk perception for doctors and medical researchers. In the second cluster, the most frequent words are decisions, information system, and support system. Tis means that AI applications can support doctors and medical researchers in decision-making. Information coming from AI technologies can be used to consider difcult problems and support a more straightforward and rapid decisionmaking process. In the third cluster, it is vital to highlight that the ML model can deal with vast amounts of data. From those inputs, it can return outcomes that can optimise the work of healthcare organisations and scheduling of medical activities.

Furthermore, the word cloud in Fig.  8 highlights aspects of AI in healthcare, such as decision support systems, decision-making, health services management, learning systems, ML techniques and diseases. Te fgure depicts how AI is linked to healthcare and how it is used in medicine.

Figure 9 represents the search trends based on the keywords analysed. Te research started in 2012. First, it identifed research topics related to clinical decision support systems. Tis topic was recurrent during the following years. Interestingly, in 2018, studies investigated AI and natural language processes as possible tools to manage patients and administrative elements. Finally, a new research stream considers AI’s role in fghting COVID-19 [65, 66].

<html><body><table><tr><td rowspan="3">artificialintelligence</td><td rowspan="2">healthcare</td><td rowspan="2"></td><td>supperisiustem</td><td>covid-19</td><td>dasariptive</td><td>intenet</td><td>inmedials</td><td>mhealth</td><td>prescrpgtive</td></tr><tr><td>natural language processing</td><td>predictive</td><td>artificial clinical depsion</td><td></td><td></td><td>ontology</td><td>textmining</td></tr><tr><td rowspan="2"></td><td>data analytics</td><td>telemedicine</td><td>systems electronic health</td><td>velocity veracity</td><td></td><td></td><td>comuii-thlt</td><td></td></tr><tr><td>deep learning datamining</td><td>decisionsupurt</td><td>ai</td><td>records intoeaties</td><td>volume</td><td></td><td></td><td></td><td></td></tr><tr><td>machine learning</td><td colspan="2">big data</td><td>classification</td><td>cliniel deisienn</td><td>image</td><td></td><td></td><td></td><td></td></tr></table></body></html>

![](images/ad57e8da7ad702f94fda575bbac16c8c787255dd21fe5ff49bb75b8dde8ee20a.jpg)  
Fig. 7 Topic dendrogram. Source: Authors’ elaboration

![](images/3abe040c8d808227fc56dd813777827047f07d3820e43dbb943f9b8f6acdb102.jpg)  
Fig. 8 Word cloud. Source: Authors’ elaboration

Table  9 represents the number of citations from other articles within the top 20 rankings. Te analysis allows the benchmark studies in the feld to be identifed [48]. For instance, Burke et  al. [67] writes the most cited paper and analyses efcient nurse rostering methodologies. Te paper critically evaluates tangible interdisciplinary solutions that also include AI. Immediately thereafter, Ahmed M.A.’s article proposes a data-driven optimisation methodology to determine the optimal number of healthcare staf to optimise patients’ productivity [68]. Finally, the third most cited article lays the groundwork for developing deep learning by considering diverse health and administrative information [51].

![](images/be7c652f0aeb7bd0ec92134c113f68aa09012d0a64725421088f3a34586ceb00.jpg)  
Fig. 9 Keywords frequency. Source: Authors’ elaboration

diferent continents, highlighting a growing interest in AI in healthcare. Te fgure shows that many areas, such as Russia, Eastern Europe and Africa except for Algeria, Egypt, and Morocco, have still not engaged in this scientifc debate.

#

Tis section analyses the difusion of AI in healthcare around the world. It highlights countries to show the geographies of this research. It includes all published articles, the total number of citations, and the collaboration network. Te following sub-sections start with an analysis of the total number of published articles.

# Country total articles

Figure  9 and Table  10 display the countries where AI in healthcare has been considered. Te USA tops the list of countries with the maximum number of articles on the topic (215). It is followed by China (83), the UK (54), India (51), Australia (54), and Canada (32). It is immediately evident that the theme has developed on

# Country publications and collaboration map

Tis section discusses articles on AI in healthcare in terms of single or multiple publications in each country. It also aims to observe collaboration and networking between countries. Table 11 and Fig. 10 highlight the average citations by state and show that the UK, the USA, and Kuwait have a higher average number of citations than other countries. Italy, Spain and New Zealand have the most signifcant number of citations.

Figure  11 depicts global collaborations. Te blue colour on the map represents research cooperation among nations. Additionally, the pink border linking states indicates the extent of collaboration between authors. Te primary cooperation between nations is between the

Table 9 Authors and sources citations. Source: Authors’ elaboration   

<html><body><table><tr><td>Ranking no</td><td>Authors and their sources (top 20)</td><td>Total citations (number of citationsTotal received)</td><td>citation per year</td></tr><tr><td>1</td><td>Burke EK.,2014, JScheduling</td><td>604</td><td>33.556</td></tr><tr><td>2</td><td>Ahmed MA.,2009,Eur JOper Res</td><td>215</td><td>16.538</td></tr><tr><td>3</td><td>Shickel B.,2018,IEEEJ Biomedical Health Informat</td><td>212</td><td>53,000</td></tr><tr><td>4</td><td>Liao Y.,2011,Morb Mortal Wkly Rep</td><td>149</td><td>13.544</td></tr><tr><td>5</td><td>Fusco C.,2011,Physiother Theory Pract</td><td>78</td><td>7.090</td></tr><tr><td>6</td><td>Baig MM.,2017,JMed Syst</td><td>76</td><td>15.200</td></tr><tr><td>7</td><td>Yeh JY.,2011, Decision Support Syst</td><td>76</td><td>6.909</td></tr><tr><td>8</td><td>Santosh KC.,2020,JMed Syst</td><td>72</td><td>36.000</td></tr><tr><td>9</td><td>Classen DC.,1992, Hosp Pharm</td><td>60</td><td>2.000</td></tr><tr><td>10</td><td>Mozaffari-Kermani M.,2015,IEEJBiomedical Health Informat</td><td>58</td><td>8.286</td></tr><tr><td>11</td><td>Yan H.,2015,JManag Anal</td><td>55</td><td>7.857</td></tr><tr><td>12</td><td>Longoni C., 2019,JConsum Res</td><td>44</td><td>14.667</td></tr><tr><td>13</td><td>Isern D.,2016,JMed Syst</td><td>44</td><td>7.333</td></tr><tr><td>14</td><td>Gayathri KS.,2015,Pers Ubiquitous Comp</td><td>44</td><td>6.286</td></tr><tr><td>15</td><td>Ben Ayed M.,2010, Decision Support Syst</td><td>44</td><td>3.667</td></tr><tr><td>16</td><td>Reiner B.,2010,JDigit Imaging</td><td>44</td><td>3.667</td></tr><tr><td>17</td><td>Li Y., 2016, Inf Sci</td><td>43</td><td>7.167</td></tr><tr><td>18</td><td>Rahulamathavan Y,2014,IEEE J Biomedical Health Informat</td><td>41</td><td>5.125</td></tr><tr><td>19</td><td>Johnson MP.,2014, Decision Support System</td><td>37</td><td>4.625</td></tr><tr><td>20</td><td>Gmez-Valejo HJ.,2016, Decision Support Syst</td><td>36</td><td>6.000</td></tr></table></body></html>

Table 10 Total number of articles per country. Source: Authors’ elaboration   

<html><body><table><tr><td>Country</td><td>Total number of articles</td></tr><tr><td>USA</td><td>215</td></tr><tr><td>China</td><td>83</td></tr><tr><td>UK</td><td>54</td></tr><tr><td>India</td><td>51</td></tr><tr><td>Australia</td><td>34</td></tr><tr><td>Canada</td><td>32</td></tr><tr><td>South Korea</td><td>28</td></tr><tr><td>Spain</td><td>21</td></tr><tr><td>Italy</td><td>20</td></tr><tr><td>Germany</td><td>13</td></tr><tr><td>France</td><td>11</td></tr><tr><td>Iran</td><td>11</td></tr><tr><td>Turkey</td><td>11</td></tr><tr><td>Finland</td><td>9</td></tr><tr><td>Greece</td><td>9</td></tr><tr><td>Portugal</td><td>9</td></tr><tr><td>Netherlands</td><td>8</td></tr><tr><td>Norway</td><td>7</td></tr></table></body></html>

Table 11 Country and their total number of citations. Source: Authors’ elaboration   

<html><body><table><tr><td>Country</td><td>Total citations</td><td>Average article citations</td></tr><tr><td>UK</td><td>680</td><td>97.14</td></tr><tr><td>USA</td><td>545</td><td>17.58</td></tr><tr><td>Kuwait</td><td>215</td><td>215.00</td></tr><tr><td>Italy</td><td>161</td><td>17.89</td></tr><tr><td>Spain</td><td>122</td><td>20.33</td></tr><tr><td>New Zealand</td><td>112</td><td>56.00</td></tr><tr><td>China</td><td>107</td><td>10.70</td></tr><tr><td>Korea</td><td>51</td><td>5.10</td></tr><tr><td>Tunisia</td><td>48</td><td>24.00</td></tr><tr><td>Australia</td><td>36</td><td>18.00</td></tr><tr><td>Canada</td><td>35</td><td>5.00</td></tr><tr><td>Hong Kong</td><td>31</td><td>7.75</td></tr><tr><td>Greece</td><td>30</td><td>30.00</td></tr><tr><td>Japan</td><td>29</td><td>29.00</td></tr></table></body></html>

USA and China, with two collaborative articles. Other collaborations among nations are limited to a few papers.

![](images/0895f264c6a930ca353c4fc0b2310fca42af8a6962365d4ea3163149538dcf0c.jpg)  
Fig. 10 Articles per country. Source: Authors’ elaboration

# Artifcial intelligence for healthcare: applications

Tis section aims to strengthen the research scope by answering RQ3: What are the research applications of artifcial intelligence for healthcare?

Benefting from the topical dendrogram, researchers will provide a development model based on four relevant variables [69, 70]. AI has been a disruptive innovation in healthcare [4]. With its sophisticated algorithms and several applications, AI has assisted doctors and medical professionals in the domains of health information systems, geocoding health data, epidemic and syndromic surveillance, predictive modelling and decision support, and medical imaging [2, 9, 10, 64]. Furthermore, the researchers considered the bibliometric analysis to identify four macro-variables dominant in the feld and used them as authors’ keywords. Terefore, the following sub-sections aim to explain the debate on applications in healthcare for AI techniques. Tese elements are shown in Fig. 12.

administrators in their work. For instance, an AI system can provide health professionals with constant, possibly real-time medical information updates from various sources, including journals, textbooks, and clinical practices [2, 10]. Tese applications’ strength is becoming even more critical in the COVID-19 period, during which information exchange is continually needed to properly manage the pandemic worldwide [71]. Other applications involve coordinating information tools for patients and enabling appropriate inferences for health risk alerts and health outcome prediction [72]. AI applications allow, for example, hospitals and all health services to work more efciently for the following reasons:

• Clinicians can access data immediately when they need it.   
+ Nurses can ensure better patient safety while administering medication. Patients can stay informed and engaged in their care by communicating with their medical teams during hospital stays.

# Health services management

One of the notable aspects of AI techniques is potential support for comprehensive health services management. Tese applications can support doctors, nurses and

Additionally, AI can contribute to optimising logistics processes, for instance, realising drugs and equipment in a just-in-time supply system based totally on predictive algorithms [73, 74]. Interesting applications can also support the training of personnel working in health services. Tis evidence could be helpful in bridging the gap between urban and rural health services [75]. Finally, health services management could beneft from AI to leverage the multiplicity of data in electronic health records by predicting data heterogeneity across hospitals and outpatient clinics, checking for outliers, performing clinical tests on the data, unifying patient representation, improving future models that can predict diagnostic tests and analyses, and creating transparency with benchmark data for analysing services delivered [51, 76].

![](images/18a1d91bf86f1ee63526f125d1e0ce194c4b4915137816cce10ff64103fb79e1.jpg)  
Fig. 11 Collaboration map. Source: Authors’ elaboration

# Predictive medicine

Another relevant topic is AI applications for disease prediction and diagnosis treatment, outcome prediction and prognosis evaluation [72, 77]. Because AI can identify meaningful relationships in raw data, it can support diagnostic, treatment and prediction outcomes in many medical situations [64]. It allows medical professionals to embrace the proactive management of disease onset. Additionally, predictions are possible for identifying risk factors and drivers for each patient to help target healthcare interventions for better outcomes [3]. AI techniques can also help design and develop new drugs, monitor patients and personalise patient treatment plans [78]. Doctors beneft from having more time and concise data to make better patient decisions. Automatic learning through AI could disrupt medicine, allowing prediction models to be created for drugs and exams that monitor patients over their whole lives [79].

# Clinical decision‑making

One of the keyword analysis main topics is that AI applications could support doctors and medical researchers in the clinical decision-making process. According to Jiang et  al. [64], AI can help physicians make better clinical decisions or even replace human judgement in healthcare-specifc functional areas. According to Bennett and Hauser [80], algorithms can beneft clinical decisions by accelerating the process and the amount of care provided, positively impacting the cost of health services. Terefore, AI technologies can support medical professionals in their activities and simplify their jobs [4]. Finally, as Redondo and Sandoval [81] fnd, algorithmic platforms can provide virtual assistance to help doctors understand the semantics of language and learning to solve business process queries as a human being would.

![](images/764a5e8ea30f57486aa131252de9354af2e9d4bd728757e1ceba0c3fd7e0eb99.jpg)  
Fig. 12 Dominant variables for AI in healthcare. Source: Authors’ elaboration

# Patient data and diagnostics

Another challenging topic related to AI applications is patient data and diagnostics. AI techniques can help medical researchers deal with the vast amount of data from patients (i.e., medical big data). AI systems can manage data generated from clinical activities, such as screening, diagnosis, and treatment assignment. In this way, health personnel can learn similar subjects and associations between subject features and outcomes of interest [64].

Tese technologies can analyse raw data and provide helpful insights that can be used in patient treatments. Tey can help doctors in the diagnostic process; for example, to realise a high-speed body scan, it will be simpler to have an overall patient condition image. Ten, AI technology can recreate a 3D mapping solution of a patient’s body.

In terms of data, interesting research perspectives are emerging. For instance, we observed the emergence of a stream of research on patient data management and protection related to AI applications [82].

For diagnostics, AI techniques can make a diference in rehabilitation therapy and surgery. Numerous robots have been designed to support and manage such tasks. Rehabilitation robots physically support and guide, for example, a patient’s limb during motor therapy [83]. For surgery, AI has a vast opportunity to transform surgical robotics through devices that can perform semiautomated surgical tasks with increasing efciency. Te fnal aim of this technology is to automate procedures to negate human error while maintaining a high level of accuracy and precision [84]. Finally, the -19 period has led to increased remote patient diagnostics through telemedicine that enables remote observation of patients and provides physicians and nurses with support tools [66, 85, 86].

# Discussion

Tis study aims to provide a bibliometric analysis of publications on AI in healthcare, focusing on accounting, business and management, decision sciences and health profession studies. Using the SLR method of Massaro et  al. [11], we provide a reliable and replicable research protocol for future studies in this feld. Additionally, we investigate the trend of scientifc publications on the subject, unexplored information, future directions, and implications using the science mapping workfow. Our analysis provides interesting insights.

In terms of bibliometric variables, the four leading journals, Journal of Medical Systems, Studies in Health Technology and Informatics, IEEE Journal of Biomedical and Health Informatics, and Decision Support Systems, are optimal locations for the publication of scientifc articles on this topic. Tese journals deal mainly with healthcare, medical information systems, and applications such as cloud computing, machine learning, and AI. Additionally, in terms of h-index, Bushko R.G. and Liu C. are the most productive and impactful authors in this research stream. Burke et  al.’s [67] contribution is the most cited with an analysis of nurse rostering using new technologies such as AI. Finally, in terms of keywords, co-occurrence reveals some interesting insights. For instance, researchers have found that AI has a role in diagnostic accuracy and helps in the analysis of health data by comparing thousands of medical records, experiencing automatic learning with clinical alerts, efcient management of health services and places of care, and the possibility of reconstructing patient history using these data.

Second, this paper fnds fve cluster analyses in healthcare applications: health services management, predictive medicine, patient data, diagnostics, and fnally, clinical decision-making. Tese technologies can also contribute to optimising logistics processes in health services and allowing a better allocation of resources.

Tird, the authors analysing the research fndings and the issues under discussion strongly support AI’s role in decision support. Tese applications, however, are demonstrated by creating a direct link to data quality management and the technology awareness of health personnel [87].

# The importance of data quality for the decision‑making process

Several authors have analysed AI in the healthcare research stream, but in this case, the authors focus on other literature that includes business and decision-making processes. In this regard, the analysis of the search fow reveals a double view of the literature. On the one hand, some contributions belong to the positivist literature and embrace future applications and implications of technology for health service management, data analysis and diagnostics [6, 80, 88]. On the other hand, some investigations also aim to understand the darker sides of technology and its impact. For example, as Carter [89] states, the impact of AI is multi-sectoral; its development, however, calls for action to protect personal data. Similarly, Davenport and Kalakota [77] focus on the ethical implications of using AI in healthcare. According to the authors, intelligent machines raise issues of accountability, transparency, and permission, especially in automated communication with patients. Our analysis does not indicate a marked strand of the literature; therefore, we argue that the discussion of elements such as the transparency of technology for patients is essential for the development of AI applications.

A large part of our results shows that, at the application level, AI can be used to improve medical support for patients (Fig.  11) [64, 82]. However, we believe that, as indicated by Kalis et  al. [90] on the pages of Harvard Business Review, the management of costly back-ofce problems should also be addressed.

Te potential of algorithms includes data analysis. Tere is an immense quantity of data accessible now, which carries the possibility of providing information about a wide variety of medical and healthcare activities [91]. With the advent of modern computational methods, computer learning and AI techniques, there are numerous possibilities [79, 83, 84]. For example, AI makes it easier to turn data into concrete and actionable observations to improve decision-making, deliver high-quality patient treatment, adapt to real-time emergencies, and save more lives on the clinical front. In addition, AI makes it easier to leverage capital to develop systems and facilities and reduce expenses at the organisational level [78]. Studying contributions to the topic, we noticed that data accuracy was included in the debate, indicating that a high standard of data will beneft decision-making practitioners [38, 77]. AI techniques are an essential instrument for studying data and the extraction of medical insight, and they may assist medical researchers in their practices. Using computational tools, healthcare stakeholders may leverage the power of data not only to evaluate past data (descriptive analytics) but also to forecast potential outcomes (predictive analytics) and to defne the best actions for the present scenario (prescriptive analytics) [78]. Te current abundance of evidence makes it easier to provide a broad view of patient health; doctors should have access to the correct details at the right time and location to provide the proper treatment [92].

# Will medical technology de‑skill doctors?

Further refection concerns the skills of doctors. Studies have shown that healthcare personnel are progressively being exposed to technology for diferent purposes, such as collecting patient records or diagnosis [71]. Tis is demonstrated by the keywords (Fig.  6) that focus on technology and the role of decision-making with new innovative tools. In addition, the discussion expands with Lu [93], which indicates that the excessive use of technology could hinder doctors’ skills and clinical procedures’ expansion. Among the main issues arising from the literature is the possible de-skilling of healthcare staf due to reduced autonomy in decision-making concerning patients [94]. Terefore, the challenges and discussion we uncovered in Fig. 11 are expanded by also considering the ethical implications of technology and the role of skills.

# Implications

Our analysis also has multiple theoretical and practical implications.

In terms of theoretical contribution, this paper extends the previous results of Connelly et  al., dos Santos et  al, Hao et  al., Huang et  al., Liao et  al. and Tran et  al. [2, 19–22, 24] in considering AI in terms of clinical decisionmaking and data management quality.

In terms of practical implications, this paper aims to create a fruitful discussion with healthcare professionals and administrative staf on how AI can be at their service to increase work quality. Furthermore, this investigation ofers a broad comprehension of bibliometric variables of AI techniques in healthcare. It can contribute to advancing scientifc research in this feld.

# Limitations

Like any other, our study has some limitations that could be addressed by more in-depth future studies. For example, using only one research database, such as Scopus, could be limiting. Further analysis could also investigate the PubMed, IEEE, and Web of Science databases individually and holistically, especially the health parts. Ten, the use of search terms such as "Artifcial Intelligence" OR "AI" AND "Healthcare" could be too general and exclude interesting studies. Moreover, although we analysed 288 peer-reviewed scientifc papers, because the new research topic is new, the analysis of conference papers could return interesting results for future researchers. Additionally, as this is a young research area, the analysis will be subject to recurrent obsolescence as multiple new research investigations are published. Finally, although bibliometric analysis has limited the subjectivity of the analysis [15], the verifcation of recurring themes could lead to diferent results by indicating areas of signifcant interest not listed here.

# Future research avenues

Concerning future research perspectives, researchers believe that an analysis of the overall amount that a healthcare organisation should pay for AI technologies could be helpful. If these technologies are essential for health services management and patient treatment, governments should invest and contribute to healthcare organisations’ modernisation. New investment funds could be made available in the healthcare world, as in the European case with the Next Generation EU programme or national investment programmes [95]. Additionally, this should happen especially in the poorest countries around the world, where there is a lack of infrastructure and services related to health and medicine [96].  On the other hand, it might be interesting to evaluate additional profts generated by healthcare organisations with AI technologies compared to those that do not use such technologies.

Further analysis could also identify why some parts of the world have not conducted studies in this area. It would be helpful to carry out a comparative analysis between countries active in this research feld and countries that are not currently involved. It would make it possible to identify variables afecting AI technologies’ presence or absence in healthcare organisations. Te results of collaboration between countries also present future researchers with the challenge of greater exchanges between researchers and professionals. Terefore, further research could investigate the diference in vision between professionals and academics.

In the accounting, business, and management research area, there is currently a lack of quantitative analysis of the costs and profts generated by healthcare organisations that use AI technologies. Terefore, research in this direction could further increase our understanding of the topic and the number of healthcare organisations that can access technologies based on AI. Finally, as suggested in the discussion section, more interdisciplinary studies are needed to strengthen AI links with data quality management and AI and ethics considerations in healthcare.

# Conclusion

In pursuing the philosophy of Massaro et al.’s [11] methodological article, we have climbed on the shoulders of giants, hoping to provide a bird’s-eye view of the AI literature in healthcare. We performed this study with a bibliometric analysis aimed at discovering authors, countries of publication and collaboration, and keywords and themes. We found a fast-growing, multi-disciplinary stream of research that is attracting an increasing number of authors.

Te research, therefore, adopts a quantitative approach to the analysis of bibliometric variables and a qualitative approach to the study of recurring keywords, which has allowed us to demonstrate strands of literature that are not purely positive. Tere are currently some limitations that will afect future research potential, especially in ethics, data governance and the competencies of the health workforce.

# Acknowledgements

The authors are grateful to the Editor-in-Chief for the suggestions and all the reviewers who spend a part of their time ensuring constructive feedback to our research article.

# Authors’ contributions

SS and PB, Supervision; Validation, writing, AS and VM; Formal analysis, DC and AS; Methodology, DC; Writing; DC, SS and AS; conceptualization, VM, PB; validation, VM, PB. All authors read and approved the fnal manuscript.

# Funding

This research received no specifc grant from any funding agency in the public, commercial, or not-for-proft sectors.

# Availability of data and materials

All the data are retrieved from public scientifc platforms.

# Declarations

Ethical approval and consent to participate Not applicable.

Consent for publication Not applicable.

# Competing interests

The authors declare that they have no known competing fnancial interests or personal relationships that could have appeared to infuence the work reported in this paper.

# Author details

1 Department of Management, University of Turin, Turin, Italy. 2 Ospedale Pediatrico Bambino Gesù, Rome, Italy. 3 Institute of Child Health, University College London, London, UK.

Received: 24 December 2020 Accepted: 1 April 2021   
Published online:10 April 2021

# References

1. Tagliaferri SD, Angelova M, Zhao X, Owen PJ, Miller CT, Wilkin T, et al. Artifcial intelligence to improve back pain outcomes and lessons learnt from clinical classifcation approaches: three systematic reviews. NPJ Digit Med. 2020;3(1):1–16.   
2. Tran BX, Vu GT, Ha GH, Vuong Q-H, Ho M-T, Vuong T-T, et al. Global evolution of research in artifcial intelligence in health and medicine: a bibliometric study. J Clin Med. 2019;8(3):360.   
3. Hamid S. The opportunities and risks of artifcial intelligence in medicine and healthcare [Internet]. 2016 [cited 2020 May 29]. http://www.cuspe. org/wp-content/uploads/2016/09/Hamid_2016.pdf   
4. Panch T, Szolovits P, Atun R. Artifcial intelligence, machine learning and health systems. J Glob Health. 2018;8(2):020303.   
5. Yang X, Wang Y, Byrne R, Schneider G, Yang S. Concepts of artifcial intelligence for computer-assisted drug discovery | chemical reviews. Chem Rev. 2019;119(18):10520–94.   
6. Burton RJ, Albur M, Eberl M, Cuf SM. Using artifcial intelligence to reduce diagnostic workload without compromising detection of urinary tract infections. BMC Med Inform Decis Mak. 2019;19(1):171.   
7. Meskò B, Drobni Z, Bényei E, Gergely B, Gyorfy Z. Digital health is a cultural transformation of traditional healthcare. Mhealth. 2017;3:38.   
8. Cho B-J, Choi YJ, Lee M-J, Kim JH, Son G-H, Park S-H, et al. Classifcation of cervical neoplasms on colposcopic photography using deep learning. Sci Rep. 2020;10(1):13652.   
9. Doyle OM, Leavitt N, Rigg JA. Finding undiagnosed patients with hepatitis C infection: an application of artifcial intelligence to patient claims data. Sci Rep. 2020;10(1):10521.   
10. Shortlife EH, Sepúlveda MJ. Clinical decision support in the era of artifcial intelligence. JAMA. 2018;320(21):2199–200.   
11. Massaro M, Dumay J, Guthrie J. On the shoulders of giants: undertaking a structured literature review in accounting. Account Auditing Account J. 2016;29(5):767–801.   
12. Junquera B, Mitre M. Value of bibliometric analysis for research policy: a case study of Spanish research into innovation and technology management. Scientometrics. 2007;71(3):443–54.   
13. Casadesus-Masanell R, Ricart JE. How to design a winning business model. Harvard Business Review [Internet]. 2011 Jan 1 [cited 2020 Jan 8]. https://hbr.org/2011/01/how-to-design-a-winning-business-model   
14. Aria M, Cuccurullo C. bibliometrix: an R-tool for comprehensive science mapping analysis. J Informetr. 2017;11(4):959–75.   
15. Zupic I, Čater T. Bibliometric methods in management and organization. Organ Res Methods. 2015;1(18):429–72.   
16. Secinaro S, Calandra D. Halal food: structured literature review and research agenda. Br Food J. 2020. https://doi.org/10.1108/ BFJ-03-2020-0234.   
17. Rialp A, Merigó JM, Cancino CA, Urbano D. Twenty-fve years (1992–2016) of the international business review: a bibliometric overview. Int Bus Rev. 2019;28(6):101587.   
18. Zhao L, Dai T, Qiao Z, Sun P, Hao J, Yang Y. Application of artifcial intelligence to wastewater treatment: a bibliometric analysis and systematic review of technology, economy, management, and wastewater reuse. Process Saf Environ Prot. 2020;1(133):169–82.   
19. Huang Y, Huang $\mathrm { \Delta Q }$ Ali S, Zhai X, Bi X, Liu R. Rehabilitation using virtual reality technology: a bibliometric analysis, 1996–2015. Scientometrics. 2016;109(3):1547–59.   
20. Hao T, Chen X, Li G, Yan J. A bibliometric analysis of text mining in medical research. Soft Comput. 2018;22(23):7875–92.   
21. dos Santos BS, Steiner MTA, Fenerich AT, Lima RHP. Data mining and machine learning techniques applied to public health problems: a bibliometric analysis from 2009 to 2018. Comput Ind Eng. 2019;1(138):106120.   
22. Liao H, Tang M, Luo L, Li C, Chiclana F, Zeng X-J. A bibliometric analysis and visualization of medical big data research. Sustainability. 2018;10(1):166.   
23. Choudhury A, Renjilian E, Asan O. Use of machine learning in geriatric clinical care for chronic diseases: a systematic literature review. JAMIA Open. 2020;3(3):459–71.   
24. Connelly TM, Malik Z, Sehgal R, Byrnes G, Cofey JC, Peirce C. The 100 most infuential manuscripts in robotic surgery: a bibliometric analysis. J Robot Surg. 2020;14(1):155–65.   
25. Guo Y, Hao Z, Zhao S, Gong J, Yang F. Artifcial intelligence in health care: bibliometric analysis. J Med Internet Res. 2020;22(7):e18228.   
26. Choudhury A, Asan O. Role of artifcial intelligence in patient safety outcomes: systematic literature review. JMIR Med Inform. 2020;8(7):e18599.   
27. Forliano C, De Bernardi P, Yahiaoui D. Entrepreneurial universities: a bibliometric analysis within the business and management domains. Technol Forecast Soc Change. 2021;1(165):120522.   
28. Secundo G, Del Vecchio P, Mele G. Social media for entrepreneurship: myth or reality? A structured literature review and a future research agenda. Int J Entrep Behav Res. 2020;27(1):149–77.   
29. Dal Mas F, Massaro M, Lombardi R, Garlatti A. From output to outcome measures in the public sector: a structured literature review. Int J Organ Anal. 2019;27(5):1631–56.   
30. Baima G, Forliano C, Santoro G, Vrontis D. Intellectual capital and business model: a systematic literature review to explore their linkages. J Intellect Cap. 2020. https://doi.org/10.1108/JIC-02-2020-0055.   
31. Dumay J, Guthrie J, Puntillo P. IC and public sector: a structured literature review. J Intellect Cap. 2015;16(2):267–84.   
32. Dal Mas F, Garcia-Perez A, Sousa MJ, Lopes da Costa R, Cobianchi L. Knowledge translation in the healthcare sector. A structured literature review. Electron J Knowl Manag. 2020;18(3):198–211.   
33. Mas FD, Massaro M, Lombardi R, Biancuzzi H. La performance nel settore pubblico tra misure di out-put e di outcome. Una revisione strutturata della letteratura ejvcbp. 2020;1(3):16–29.   
34. Dumay J, Cai L. A review and critique of content analysis as a methodology for inquiring into IC disclosure. J Intellect Cap. 2014;15(2):264–90.   
35. Haleem A, Javaid M, Khan IH. Current status and applications of Artifcial Intelligence (AI) in medical feld: an overview. Curr Med Res Pract. 2019;9(6):231–7.   
36. Paul J, Criado AR. The art of writing literature review: what do we know and what do we need to know? Int Bus Rev. 2020;29(4):101717.   
37. Liberati A, Altman DG, Tetzlaf J, Mulrow C, Gøtzsche PC, Ioannidis JPA, et al. The PRISMA statement for reporting systematic reviews and metaanalyses of studies that evaluate health care interventions: explanation and elaboration. PLoS Med. 2009;6(7):e1000100.   
38. Biancone PP, Secinaro S, Brescia V, Calandra D. Data quality methods and applications in health care system: a systematic literature review. Int J Bus Manag. 2019;14(4):p35.   
39. Secinaro S, Brescia V, Calandra D, Verardi GP, Bert F. The use of micafungin in neonates and children: a systematic review. ejvcbp. 2020;1(1):100–14.   
40. Bert F, Gualano MR, Biancone P, Brescia V, Camussi E, Martorana M, et al. HIV screening in pregnant women: a systematic review of cost-efectiveness studies. Int J Health Plann Manag. 2018;33(1):31–50.   
41. Levy Y, Ellis TJ. A systems approach to conduct an efective literature review in support of information systems research. Inf Sci Int J Emerg Transdiscipl. 2006;9:181–212.   
42. Chen G, Xiao L. Selecting publication keywords for domain analysis in bibliometrics: a comparison of three methods. J Informet. 2016;10(1):212–23.   
43. Falagas ME, Pitsouni EI, Malietzis GA, Pappas G. Comparison of PubMed, Scopus, Web of Science, and Google Scholar: strengths and weaknesses. FASEB J. 2007;22(2):338–42.   
44. Sicilia M-A, Garcìa-Barriocanal E, Sànchez-Alonso S. Community curation in open dataset repositories: insights from zenodo. Procedia Comput Sci. 2017;1(106):54–60.   
45. Secinaro S, Calandra D, Secinaro A, Muthurangu V, Biancone P. Artifcial Intelligence for healthcare with a business, management and accounting, decision sciences, and health professions focus [Internet]. Zenodo; 2021 [cited 2021 Mar 7]. https://zenodo.org/record/4587618#.YEScpl1KiWh.   
46. Elango B, Rajendran D. Authorship trends and collaboration pattern in the marine sciences literature: a scientometric Study. Int J Inf Dissem Technol. 2012;1(2):166–9.   
47. Jacoby WG. Electoral inquiry section Loess: a nonparametric, graphical tool for depicting relationships between variables q. In 2000.   
48. Andrews JE. An author co-citation analysis of medical informatics. J Med Libr Assoc. 2003;91(1):47–56.   
49. White HD, Grifth BC. Author cocitation: a literature measure of intellectual structure. J Am Soc Inf Sci. 1981;32(3):163–71.   
50. Santosh KC. AI-driven tools for coronavirus outbreak: need of active learning and cross-population train/test models on multitudinal/multimodal data. J Med Syst. 2020;44(5):93.   
51. Shickel B, Tighe PJ, Bihorac A, Rashidi P. Deep EHR: a survey of recent advances in deep learning techniques for electronic health record (EHR) analysis. IEEE J Biomed Health Inform. 2018;22(5):1589–604.   
52. Baig MM, GholamHosseini H, Moqeem AA, Mirza F, Lindén M. A systematic review of wearable patient monitoring systems—current challenges and opportunities for clinical adoption. J Med Syst. 2017;41(7):115.   
53. Kumar S, Kumar S. Collaboration in research productivity in oil seed research institutes of India. In: Proceedings of fourth international conference on webometrics, informetrics and scientometrics. p. 28–1; 2008.   
54. Gatto A, Drago C. A taxonomy of energy resilience. Energy Policy. 2020;136:111007.   
55. Levitt JM, Thelwall M. Alphabetization and the skewing of frst authorship towards last names early in the alphabet. J Informet. 2013;7(3):575–82.   
56. Saad G. Exploring the h-index at the author and journal levels using bibliometric data of productive consumer scholars and businessrelated journals respectively. Scientometrics. 2006;69(1):117–20.   
57. Egghe L. Theory and practise of the g-index. Scientometrics. 2006;69(1):131–52.   
58. Schreiber M. A modifcation of the h-index: the hm-index accounts for multi-authored manuscripts. J Informet. 2008;2(3):211–6.   
59. Engqvist L, Frommen JG. The h-index and self-citations. Trends Ecol Evol. 2008;23(5):250–2.   
60. London School of Economics. 3: key measures of academic infuence [Internet]. Impact of social sciences. 2010 [cited 2021 Jan 13]. https:// blogs.lse.ac.uk/impactofsocialsciences/the-handbook/chapter-3-keymeasures-of-academic-infuence/.   
61. Lotka A. The frequency distribution of scientifc productivity. J Wash Acad Sci. 1926;16(12):317–24.   
62. Khan G, Wood J. Information technology management domain: emerging themes and keyword analysis. Scientometrics. 2015;9:105.   
63. Oxford University Press. Oxford English Dictionary [Internet]. 2020. https://www.oed.com/.   
64. Jiang F, Jiang Y, Zhi H, Dong Y, Li H, Ma S, et al. Artifcial intelligence in healthcare: past, present and future. Stroke Vasc Neurol. 2017;2(4):230–43.   
65. Calandra D, Favareto M. Artifcial Intelligence to fght COVID19 outbreak impact: an overview. Eur J Soc Impact Circ Econ. 2020;1(3):84–104.   
66. Bokolo Anthony Jnr. Use of telemedicine and virtual care for remote treatment in response to COVID-19 pandemic. J Med Syst. 2020;44(7):132.   
67. Burke EK, De Causmaecker P, Berghe GV, Van Landeghem H. The state of the art of nurse rostering. J Sched. 2004;7(6):441–99.   
68. Ahmed MA, Alkhamis TM. Simulation optimization for an emergency department healthcare unit in Kuwait. Eur J Oper Res. 2009;198(3):936–42.   
69. Forina M, Armanino C, Raggio V. Clustering with dendrograms on interpretation variables. Anal Chim Acta. 2002;454(1):13–9.   
70. Wartena C, Brussee R. Topic detection by clustering keywords. In: 2008 19th international workshop on database and expert systems applications. 2008. p. 54–8.   
71. Hussain AA, Bouachir O, Al-Turjman F, Aloqaily M. AI Techniques for COVID-19. IEEE Access. 2020;8:128776–95.   
72. Agrawal A, Gans JS, Goldfarb A. Exploring the impact of artifcial intelligence: prediction versus judgment. Inf Econ Policy. 2019;1(47):1–6.   
73. Chakradhar S. Predictable response: fnding optimal drugs and doses using artifcial intelligence. Nat Med. 2017;23(11):1244–7.   
74. Fleming N. How artifcial intelligence is changing drug discovery. Nature. 2018;557(7707):S55–7.   
75. Guo J, Li B. The application of medical artifcial intelligence technology in rural areas of developing countries. Health Equity. 2018;2(1):174–81.   
76. Aisyah M, Cockcroft S. A snapshot of data quality issues in Indonesian community health. Int J Netw Virtual Organ. 2014;14(3):280–97.   
77. Davenport T, Kalakota R. The potential for artifcial intelligence in healthcare. Future Healthc J. 2019;6(2):94–8.   
78. Mehta N, Pandit A, Shukla S. Transforming healthcare with big data analytics and artifcial intelligence: a systematic mapping study. J Biomed Inform. 2019;1(100):103311.   
79. Collins GS, Moons KGM. Reporting of artifcial intelligence prediction models. Lancet. 2019;393(10181):1577–9.   
80. Bennett CC, Hauser K. Artifcial intelligence framework for simulating clinical decision-making: a Markov decision process approach. Artif Intell Med. 2013;57(1):9–19.   
81. Redondo T, Sandoval AM. Text Analytics: the convergence of big data and artifcial intelligence. Int J Interact Multimed Artif Intell. 2016;3. https:// www.ijimai.org/journal/bibcite/reference/2540.   
82. Winter JS, Davidson E. Big data governance of personal health information and challenges to contextual integrity. Inf Soc. 2019;35(1):36–51.   
83. Novak D, Riener R. Control strategies and artifcial intelligence in rehabilitation robotics. AI Mag. 2015;36(4):23–33.   
84. Tarassoli SP. Artifcial intelligence, regenerative surgery, robotics? What is realistic for the future of surgery? Ann Med Surg (Lond). 2019;17(41):53–5.   
85. Saha SK, Fernando B, Cuadros J, Xiao D, Kanagasingam Y. Automated quality assessment of colour fundus images for diabetic retinopathy screening in telemedicine. J Digit Imaging. 2018;31(6):869–78.   
86. Gu D, Li T, Wang X, Yang X, Yu Z. Visualizing the intellectual structure and evolution of electronic health and telemedicine research. Int J Med Inform. 2019;130:103947.   
87. Madnick S, Wang R, Lee Y, Zhu H. Overview and framework for data and information quality research. J Data Inf Qual. 2009;1:1.   
88. Chen X, Liu Z, Wei L, Yan J, Hao T, Ding R. A comparative quantitative study of utilizing artifcial intelligence on electronic health records in the USA and China during 2008–2017. BMC Med Inform Decis Mak.   
2018;18(5):117.   
89. Carter D. How real is the impact of artifcial intelligence? Bus Inf Surv.   
2018;35(3):99–115.   
90. Kalis B, Collier M, Fu R. 10 Promising AI Applications in Health Care.   
2018;5.   
91. Biancone P, Secinaro S, Brescia V, Calandra D. Management of open innovation in healthcare for cost accounting using EHR. J Open Innov Technol Market Complex. 2019;5(4):99.   
92. Kayyali B, Knott D, Van Kuiken S. The ‘big data’ revolution in US healthcare [Internet]. McKinsey & Company. 2013 [cited 2020 Aug 14]. https://healt hcare.mckinsey.com/big-data-revolution-us-healthcare/.   
93. Lu J. Will medical technology deskill doctors? Int Educ Stud.   
2016;9(7):130–4.   
94. Hof T. Deskilling and adaptation among primary care physicians using two work innovations. Health Care Manag Rev. 2011;36(4):338–48.   
95. Picek O. Spillover efects from next generation EU. Intereconomics.   
2020;55(5):325–31.   
96. Sousa MJ, Dal Mas F, Pesqueira A, Lemos C, Verde JM, Cobianchi L. The potential of AI in health higher education to increase the students’ learning outcomes. TEM J. 2021. (In press).

# Publisher’s Note

Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional afliations.

# Ready to submit your research? Choose BMC and benefit from:

• fast, convenient online submission   
• thorough peer review by experienced researchers in your field   
• rapid publication on acceptance   
• support for research data, including large and complex data types   
• gold Open Access which fosters wider collaboration and increased citations   
• maximum visibility for your research: over 100M website views per year

# At BMC, research is always in progress.

Learn more biomedcentral.com/submissions